/*
 * Decompiled with CFR 0.152.
 */
package icyllis.flexmark.util.format;

import icyllis.annotations.NotNull;
import icyllis.flexmark.util.misc.CharPredicate;

public interface CharWidthProvider {
    public static final CharWidthProvider NULL = new CharWidthProvider(){

        @Override
        public int getSpaceWidth() {
            return 1;
        }

        @Override
        public int getCharWidth(char c) {
            return 1;
        }
    };

    public int getSpaceWidth();

    public int getCharWidth(char var1);

    default public int getStringWidth(@NotNull CharSequence chars) {
        return this.getStringWidth(chars, CharPredicate.NONE);
    }

    default public int getStringWidth(@NotNull CharSequence chars, @NotNull CharPredicate zeroWidthChars) {
        int iMax = chars.length();
        int width = 0;
        for (int i = 0; i < iMax; ++i) {
            char c = chars.charAt(i);
            if (zeroWidthChars.test(c)) continue;
            width += this.getCharWidth(c);
        }
        return width;
    }
}

